{*=====================================================================
  Project:   WinCubNET.bdsproj

  File:      WinCubNET_.pas

  Summary:
             WinCubNET is a Delphi.NET implementation of the dotNETCub
             project, which is a simple game for your fun.
             On other hand it could demonstrate creating
             FCL-objects in run time and using them.

-----------------------------------------------------------------------
  This file is submitted by:

  endresy@axelero.hu
  Endre I. Simay,
  Hungary


THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.
=====================================================================*}

unit wincubNET_;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data;

type
  TWinForm = class(System.Windows.Forms.Form)
{$REGION 'Designer Managed Code'}
    strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    pnlHost: System.Windows.Forms.Panel;
    pnlSteps: System.Windows.Forms.Panel;
    btnShuffle: System.Windows.Forms.Button;
    lblStep1: System.Windows.Forms.Label;
    lblStep2: System.Windows.Forms.Label;
    lblComplett: System.Windows.Forms.Label;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure btnShuffle_Click(sender: System.Object; e: System.EventArgs);
{$ENDREGION}
    strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  public
    constructor Create;
  private
    complet,
      first,
      block,
      sp,
      steps: integer;

    colors: array[1..4] of string;

    pnlCubs: array[1..4, 1..4] of System.Windows.Forms.Panel;
    btnUp: array[1..4] of System.Windows.Forms.Button;
    btnDown: array[1..4] of System.Windows.Forms.Button;
    btnLeft: array[1..4] of System.Windows.Forms.Button;
    btnRight: array[1..4] of System.Windows.Forms.Button;

    procedure SetupForm();
    procedure ButtonUpClick(sender: System.object; e: System.EventArgs);
    procedure ButtonDownClick(sender: System.object; e: System.EventArgs);
    procedure ButtonLeftClick(sender: System.object; e: System.EventArgs);
    procedure ButtonRightClick(sender: System.object; e: System.EventArgs);

    procedure LineUp(j: integer);
    procedure LineDown(j: integer);
    procedure LineLeft(j: integer);
    procedure LineRight(j: integer);

    function ifComplet: integer;
    procedure CompParams;

  end;

implementation

uses
  System.Globalization;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>

procedure TWinForm.InitializeComponent;
begin
  Self.pnlHost := System.Windows.Forms.Panel.Create;
  Self.pnlSteps := System.Windows.Forms.Panel.Create;
  Self.lblStep2 := System.Windows.Forms.Label.Create;
  Self.lblStep1 := System.Windows.Forms.Label.Create;
  Self.btnShuffle := System.Windows.Forms.Button.Create;
  Self.lblComplett := System.Windows.Forms.Label.Create;
  Self.pnlSteps.SuspendLayout;
  Self.SuspendLayout;
  // 
  // pnlHost
  // 
  Self.pnlHost.Location := System.Drawing.Point.Create(16, 16);
  Self.pnlHost.Name := 'pnlHost';
  Self.pnlHost.Size := System.Drawing.Size.Create(232, 224);
  Self.pnlHost.TabIndex := 0;
  // 
  // pnlSteps
  // 
  Self.pnlSteps.Controls.Add(Self.lblStep2);
  Self.pnlSteps.Controls.Add(Self.lblStep1);
  Self.pnlSteps.Location := System.Drawing.Point.Create(8, 264);
  Self.pnlSteps.Name := 'pnlSteps';
  Self.pnlSteps.Size := System.Drawing.Size.Create(256, 32);
  Self.pnlSteps.TabIndex := 1;
  // 
  // lblStep2
  // 
  Self.lblStep2.Location := System.Drawing.Point.Create(160, 8);
  Self.lblStep2.Name := 'lblStep2';
  Self.lblStep2.TabIndex := 1;
  // 
  // lblStep1
  // 
  Self.lblStep1.Location := System.Drawing.Point.Create(8, 8);
  Self.lblStep1.Name := 'lblStep1';
  Self.lblStep1.TabIndex := 0;
  // 
  // btnShuffle
  // 
  Self.btnShuffle.Location := System.Drawing.Point.Create(312, 8);
  Self.btnShuffle.Name := 'btnShuffle';
  Self.btnShuffle.TabIndex := 2;
  Self.btnShuffle.Text := 'Shuffle';
  Include(Self.btnShuffle.Click, Self.btnShuffle_Click);
  // 
  // lblComplett
  // 
  Self.lblComplett.AutoSize := True;
  Self.lblComplett.ForeColor := System.Drawing.Color.Blue;
  Self.lblComplett.Location := System.Drawing.Point.Create(16, 320);
  Self.lblComplett.Name := 'lblComplett';
  Self.lblComplett.Size := System.Drawing.Size.Create(90, 16);
  Self.lblComplett.TabIndex := 3;
  Self.lblComplett.Text := 'Congratulation !!!';
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.BackColor := System.Drawing.Color.LightGray;
  Self.ClientSize := System.Drawing.Size.Create(397, 408);
  Self.Controls.Add(Self.lblComplett);
  Self.Controls.Add(Self.btnShuffle);
  Self.Controls.Add(Self.pnlSteps);
  Self.Controls.Add(Self.pnlHost);
  Self.MaximizeBox := False;
  Self.MaximumSize := System.Drawing.Size.Create(405, 435);
  Self.MinimumSize := System.Drawing.Size.Create(405, 435);
  Self.Name := 'TWinForm';
  Self.pnlSteps.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
var
  i, j: integer;
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  for i := 1 to 4 do
  begin

    if btnUp[i] <> nil then btnUp[i].Free;
    if btnDown[i] <> nil then btnDown[i].Free;
    if btnLeft[i] <> nil then btnLeft[i].Free;
    if btnRight[i] <> nil then btnRight[i].Free;

    for j := 1 to 4 do
    begin
      if pnlCubs[i, j] <> nil then pnlCubs[i, j].Free;
    end;
  end;

  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
  complet := 1;
  first := 40;
  block := 40;
  sp := 5;
  steps := 0;
  SetupForm();
end;

procedure TWinForm.SetupForm();
var
  i, j: integer;
begin
  colors[1] := 'Red';
  colors[2] := 'Lime';
  colors[3] := 'Yellow';
  colors[4] := 'Blue';

  Text := 'WinCub.NET for Delphi by E. I. Simay';

  pnlHost.Size := System.Drawing.Size.Create(2 * first + 4 * block + 3 * sp, 2 * first + 4 * block + 3 * sp);
  btnShuffle.Top := pnlHost.Top;

  for i := 1 to 4 do
  begin
    Self.btnUp[i] := System.Windows.Forms.Button.Create;
    Self.pnlHost.Controls.Add(Self.btnUp[i]);
    Self.btnUp[i].BackColor := System.Drawing.Color.Silver;
    Include(Self.btnUp[i].Click, Self.ButtonUpClick);

    Self.btnDown[i] := System.Windows.Forms.Button.Create;
    Self.pnlHost.Controls.Add(Self.btnDown[i]);
    Self.btnDown[i].BackColor := System.Drawing.Color.Silver;
    Include(Self.btnDown[i].Click, Self.ButtonDownClick);

    Self.btnLeft[i] := System.Windows.Forms.Button.Create;
    Self.pnlHost.Controls.Add(Self.btnLeft[i]);
    Self.btnLeft[i].BackColor := System.Drawing.Color.Silver;
    Include(Self.btnLeft[i].Click, Self.ButtonLeftClick);

    Self.btnRight[i] := System.Windows.Forms.Button.Create;
    Self.pnlHost.Controls.Add(Self.btnRight[i]);
    Self.btnRight[i].BackColor := System.Drawing.Color.Silver;
    Include(Self.btnRight[i].Click, Self.ButtonRightClick);

    for j := 1 to 4 do
    begin
      Self.pnlCubs[i, j] := System.Windows.Forms.Panel.Create;
      Self.pnlHost.Controls.Add(Self.pnlCubs[i, j]);
    end;
  end;

  for i := 0 to 3 do
  begin
    btnUp[i + 1].Left := first + i * block + i * sp;
    btnUp[i + 1].Top := first - 25;
    btnUp[i + 1].Width := block;
    btnUp[i + 1].Height := 20;

    btnDown[i + 1].Left := first + i * block + i * sp;
    btnDown[i + 1].Top := first + 3 * block + 3 * sp + block + 5;
    btnDown[i + 1].Width := block;
    btnDown[i + 1].Height := 20;

    btnLeft[i + 1].Left := first - 25;
    btnLeft[i + 1].Top := first + i * block + i * sp;
    btnLeft[i + 1].Width := 20;
    btnLeft[i + 1].Height := block;

    btnRight[i + 1].Left := first + 3 * block + 3 * sp + block + 5;
    btnRight[i + 1].Top := first + i * block + i * sp;
    btnRight[i + 1].Width := 20;
    btnRight[i + 1].Height := block;

    for j := 0 to 3 do
    begin
      pnlCubs[j + 1, i + 1].Width := block;
      pnlCubs[j + 1, i + 1].Height := block;
      pnlCubs[j + 1, i + 1].BackColor := System.Drawing.Color.FromName(colors[i + 1]);
      pnlCubs[j + 1, i + 1].Left := first + (j) * block + (j) * sp;
      pnlCubs[j + 1, i + 1].Top := first + (i) * block + (i) * sp;
    end;
  end;

  pnlSteps.Top := pnlHost.Bottom + 20;
  pnlSteps.Width := pnlHost.Width;

  lblStep1.Top := 8;
  lblStep1.Left := 8;
  lblStep1.Text := ' Number of steps: ';
  lblStep1.AutoSize := true;
  lblStep1.AutoSize := false;
  pnlSteps.Height := lblStep1.Height + 16;
  lblStep2.Top := lblStep1.Top;
  lblStep2.Height := lblStep1.Height;
  lblStep2.Left := lblStep1.Right + 10;
  lblStep2.Text := steps.ToString();
  btnShuffle.Enabled := (complet = 1);
  lblComplett.Left := pnlHost.Left;
  lblComplett.Font := System.Drawing.Font.Create('Microsoft Sans Serif', 24, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, (System.Byte(238)));
  lblComplett.Visible := false;

end;

function TWinForm.ifComplet: integer;
var
  i,
    tried: integer;
begin
  tried := 1;
  for i := 1 to 4 do
  begin
    if (
      (pnlCubs[i, 1].BackColor <> System.Drawing.Color.FromName(colors[1]))
      or (pnlCubs[i, 2].BackColor <> System.Drawing.Color.FromName(colors[2]))
      or (pnlCubs[i, 3].BackColor <> System.Drawing.Color.FromName(colors[3]))
      or (pnlCubs[i, 4].BackColor <> System.Drawing.Color.FromName(colors[4]))
      ) then
    begin
      tried := 0;
      break;
    end;
  end;
  result := tried;
end;

procedure TWinForm.LineUp(j: integer);
var
  tempBackColor: System.Drawing.Color;
begin
  tempBackColor := pnlCubs[j, 1].BackColor;
  pnlCubs[j, 1].BackColor := pnlCubs[j, 2].BackColor;
  pnlCubs[j, 2].BackColor := pnlCubs[j, 3].BackColor;
  pnlCubs[j, 3].BackColor := pnlCubs[j, 4].BackColor;
  pnlCubs[j, 4].BackColor := tempBackColor;
end;

procedure TWinForm.LineDown(j: integer);
var
  tempBackColor: System.Drawing.Color;
begin
  tempBackColor := pnlCubs[j, 4].BackColor;
  pnlCubs[j, 4].BackColor := pnlCubs[j, 3].BackColor;
  pnlCubs[j, 3].BackColor := pnlCubs[j, 2].BackColor;
  pnlCubs[j, 2].BackColor := pnlCubs[j, 1].BackColor;
  pnlCubs[j, 1].BackColor := tempBackColor;
end;

procedure TWinForm.LineLeft(j: integer);
var
  tempBackColor: System.Drawing.Color;
begin
  tempBackColor := pnlCubs[1, j].BackColor;
  pnlCubs[1, j].BackColor := pnlCubs[2, j].BackColor;
  pnlCubs[2, j].BackColor := pnlCubs[3, j].BackColor;
  pnlCubs[3, j].BackColor := pnlCubs[4, j].BackColor;
  pnlCubs[4, j].BackColor := tempBackColor;
end;

procedure TWinForm.LineRight(j: integer);
var
  tempBackColor: System.Drawing.Color;
begin
  tempBackColor := pnlCubs[4, j].BackColor;
  pnlCubs[4, j].BackColor := pnlCubs[3, j].BackColor;
  pnlCubs[3, j].BackColor := pnlCubs[2, j].BackColor;
  pnlCubs[2, j].BackColor := pnlCubs[1, j].BackColor;
  pnlCubs[1, j].BackColor := tempBackColor;
end;

procedure TWinForm.CompParams;
begin
  lblStep2.Text := steps.ToString;
  complet := ifComplet;
  btnShuffle.Enabled := (complet = 1);
  lblComplett.Visible := (complet = 1);
end;

procedure TWinForm.ButtonUpClick(sender: System.object; e: System.EventArgs);
var
  i: integer;
begin
  if complet <> 1 then
  begin
    for i := 1 to 4 do
    begin
      if Sender = btnUp[i] then
      begin
        LineUp(i);
        break;
      end;
    end;
    steps := steps + 1;
    CompParams;
  end;
end;

procedure TWinForm.ButtonDownClick(sender: System.object; e: System.EventArgs);
var
  i: integer;
begin
  if complet <> 1 then
  begin
    for i := 1 to 4 do
    begin
      if Sender = btnDown[i] then
      begin
        LineDown(i);
        break;
      end;
    end;
    steps := steps + 1;
    CompParams;
  end;
end;

procedure TWinForm.ButtonLeftClick(sender: System.object; e: System.EventArgs);
var
  i: integer;
begin
  if complet <> 1 then
  begin
    for i := 1 to 4 do
    begin
      if Sender = btnLeft[i] then
      begin
        LineLeft(i);
        break;
      end;
    end;
    steps := steps + 1;
    CompParams;
  end;
end;

procedure TWinForm.ButtonRightClick(sender: System.object; e: System.EventArgs);
var
  i: integer;
begin
  if complet <> 1 then
  begin
    for i := 1 to 4 do
    begin
      if Sender = btnRight[i] then
      begin
        LineRight(i);
        break;
      end;
    end;
    steps := steps + 1;
    CompParams;
  end;
end;

procedure TWinForm.btnShuffle_Click(sender: System.object; e: System.EventArgs);
var
  i: integer;
  C: System.Random;
begin
  C := System.Random.Create();
  complet := 0;
  for i := 1 to 20 do
  begin
    case C.Next(1, 4) of
      1: begin
          LineUp(C.Next(1, 4));
        end;
      2: begin
          LineDown(C.Next(1, 4));
        end;
      3: begin
          LineLeft(C.Next(1, 4));
        end;
      4: begin
          LineRight(C.Next(1, 4));
        end;
    end;
  end;
  steps := 0;
  btnShuffle.Enabled := (complet = 1);
  lblComplett.Visible := (complet = 1);
end;

end.
